<?php

App::uses('EvDiscountAppController', 'EvDiscount.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class DiscountCodesController extends EvDiscountAppController {

	/**
	 * disable filters
	 */
	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$fields[$modelAlias . '.code'] = array(
			'label' => 'Discount Code',
			'type' => 'string',
			'compare' => array(
				$modelAlias . '.code LIKE' => '%%%s%%'
			)
		);

		return $fields;
	}

	/**
	 * Paginator defaults for admin.
	 *
	 * @var array
	 */
	public $adminPaginate = array(
		'contain' => array(
			'Currency'
		),
		'conditions' => array(
			'DiscountCode.is_voucher' => false
		)
	);

	/**
	 * add code field to columns
	 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = ArrayUtil::addAfter(
			$columns,
			$modelAlias . '.name',
			array(
				$modelAlias . '.code' => array(
					'type' => 'string',
					'label' => __('Code')
				),
				'Currency.name' => array(
					'type' => 'string',
					'label' => __('Currency')
				)
			)
		);

		return $columns;
	}

	/**
	 * populate the lookups
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Model = $this->{$this->modelClass};

		$this->set(
			'discountTypes',
			$Model->DiscountType->getForDropdown()
		);

		if (CakePlugin::loaded('EvShop') && !empty($this->request->data[$Model->alias]['discount_type_id']) && $this->request->data[$Model->alias]['discount_type_id'] == 5) {
			// Load product list for free gift lookup
			$this->loadModel('EvShop.Product');
			$this->set(
				'freeGiftProducts',
				$this->Product->getForDropdown()
			);
		}
	}

	/**
	 * form fields - If this is a new code, hide most of the form fields and only allow them to set a name and a price. If this is an existing discount
	 * show all of the options but don't allow changing the discount type.
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$Model = $this->{$this->modelClass};

		if (!empty($this->request->data[$this->modelClass]['id'])) {

			// This is an existing code
			$discountType = $Model->DiscountType->find('first', [
				'conditions' => [
					'id' => $this->request->data[$this->modelClass]['discount_type_id']
				]
			]);

			$fields[$this->modelClass . '.discount_type_id']['type'] = 'hidden';
			$fields = ArrayUtil::addAfter( $fields, $this->modelClass . '.discount_type_id', [
				$this->modelClass . '.discount_type' => [
					'type' => 'string',
					'value' => $discountType['DiscountType']['name'],
					'disabled' => 'disabled'
				]
			]);

			$fields[$this->modelClass . '.min_order']['label'] = 'Minimum Order Value';

			$fields[$this->modelClass . '.times_used']['info'] = 'This value will automatically increase by one each time the code is used';
			$fields[$this->modelClass . '.maximum_uses']['info'] = 'If this value is set to greater than zero, that will be the maximum number of times this code can be used.';

			$fields[$this->modelClass . '.is_voucher']['type'] = 'hidden';
			$fields[$this->modelClass . '.is_voucher']['value'] = false;

			if (Configure::check('EvDiscount.extraFields.' . $this->request->data[$this->modelClass]['discount_type_id'])) {
				$fields = ArrayUtil::addAfter( $fields, $this->modelClass . '.name', Configure::read('EvDiscount.extraFields.' . $this->request->data[$this->modelClass]['discount_type_id']));
			}

			if (Configure::check('EvDiscount.amountField.' . $this->request->data[$this->modelClass]['discount_type_id'])) {
				$amountConfig = Configure::read('EvDiscount.amountField.' . $this->request->data[$this->modelClass]['discount_type_id']);
				if (isset($amountConfig['visible']) && empty($amountConfig['visible'])) {
					$fields[$this->modelClass . '.amount']['type'] = 'hidden';
					$fields[$this->modelClass . '.amount']['value'] = 0;
				} else {
					if (isset($amountConfig['label'])) {
						$fields[$this->modelClass . '.amount']['label'] = $amountConfig['label'];
					}
					if (isset($amountConfig['displayInfo'])) {
						$fields[$this->modelClass . '.amount']['displayInfo'] = $amountConfig['displayInfo'];
					}
				}
			}

		} else {
			// This is a new discount
			unset( $fields[$this->modelClass . '.start_date'] );
			unset( $fields[$this->modelClass . '.end_date'] );
			unset( $fields[$this->modelClass . '.min_order'] );
			unset( $fields[$this->modelClass . '.amount'] );
			unset( $fields[$this->modelClass . '.currency_id'] );
			unset( $fields[$this->modelClass . '.times_used'] );
			unset( $fields[$this->modelClass . '.maximum_uses'] );
			unset( $fields[$this->modelClass . '.code'] );
			unset( $fields[$this->modelClass . '.is_voucher'] );
			unset( $fields[$this->modelClass . '.is_active'] );
		}

		unset( $fields[$this->modelClass . '.extra_data'] );

		return $fields;
	}

	/**
	 * When adding, only allow them to set some basic information before expanding the form on save.
	 * This means we don't have to worry about updating the visible fields at runtime and prevents
	 * anyone changing discount types when transactions in progress may already be using them.
	 */
	public function admin_edit($id = null) {
		//
		if (!empty($id)) {
			$this->toInject('components', 'EvDiscount.CodeRestrictions');
			$this->toInject('components', 'EvCurrency.Currencies');
			$this->toInject('helpers', 'EvDiscount.CodeRestrictions');

			parent::admin_edit($id);

			$this->view = 'EvDiscount.DiscountCodes/admin_form';
		} else {
			parent::admin_edit($id);
		}
	}
}
