<?php

App::uses('AppComponent', 'Controller/Component');

class CodeRestrictionsComponent extends AppComponent {

	/**
	 * run the form injection
	 * For custom fields this add type / validation arrays to the template for fields
	 *
	 * @param   array $data    Data from $this->request->data
	 * @param   object $Model  Model Object for the primary model we are dealing with
	 * @param   int|null $id   The ID if on edit or null of add
	 */
	public function injectAdminForm($data, $Model, $id) {
		$restrictTo = Configure::read('EvDiscount.restrictTo');

		if (! empty($restrictTo)) {

			$restrictions = [];
			foreach ($restrictTo as $model) {
				// Only fetch shipping rules when working the Free delivery discount type
				if ($model == "EvShipping.ShippingRule" && $this->_getDiscountTypeName($data) != "Free delivery") {
					continue;
				}

				$Model = EvClassRegistry::init($model);
				$restrictions[$model]['model'] = $model;
				$restrictions[$model]['label'] = $Model->alias;
				$restrictions[$model]['data'] = $Model->find(
					'list',
					[
						'order' => $Model->alias . '.' . $Model->displayField . ' ASC'
					]
				);
			}

			$this->_controller->set('restrictions', $restrictions);
		}
	}

/**
 * Fetches the name of the discount type from the request data
 * @param   array $data    Data from $this->request->data
 * @return  string
 */
	protected function _getDiscountTypeName($data) {
		$alias = $this->_controller->{$this->_controller->modelClass}->alias;
		if (empty($data[$alias]['discount_type_id'])) {
			return false;
		}

		$discountType = EvClassRegistry::init('EvDiscount.DiscountType')->findById($data[$alias]['discount_type_id']);

		return $discountType['DiscountType']['name'];
	}
}
