<?php

App::uses('PluginInstallShell', 'shells');

class EvDiscountInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvNavigation.Menu',
		'EvDiscount.DiscountType'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		// Add to the admin menu
		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Discount Codes',
					'pattern' => '/^\/admin\/ev_discount\/discount_codes\//',
					'plugin' => 'EvDiscount',
					'controller' => 'ev_discount.discount_codes',
					'model' => 'DiscountCode',
					'action' => 'index',
					'class' => 'icon-tags',
					'is_active' => 1
				)
			)
		);

		$this->DiscountType->saveMany(
			[
				[
					'id' => 1,
					'name' => 'fixed',
					'is_active' => true
				],
				[
					'id' => 2,
					'name' => 'percent',
					'is_active' => true
				]
			]
		);
	}
}
