<?php

$config = array(
	'EvDiscount' => array(
		/**
		 * models available for restrictions
		 * 'EvPlugin.Model' => 'Modelname' format
		 */
		'restrictTo' => array(),

		/**
		 * allow multiple codes to be applied
		 */
		'multipleCodes' => false,

		/**
		 * The extra fields required for discount types
		 */
		'extraFields' => [
			5 => [ // Free gift
				'DiscountData.free_gift_product_id' => [
					'type' => 'chosen_multiselect',
					'displayInfo' => 'Specify the product to give to the user as a free gift'
				]
			],
			6 => [
				'DiscountData.quantity_to_pay_for' => [
					'type' => 'integer',
					'displayInfo' => '(Y) Specify how many of the qualifying items will need to be paid for once X items have been purchased'
				]
			],
			8 => [
				'DiscountData.fixed_price' => [
					'type' => 'decimal',
					'displayInfo' => '(Y) Fixed price'
				],
			],
		],

		/**
		 * The amount field changes per discount type
		 */
		'amountField' => [
			1 => [ // Fixed
				'label' => 'Amount',
				'displayInfo' => 'Specify the total amount of discount the user will receive'
			],
			2 => [ // Percentage
				'label' => 'Percentage',
				'displayInfo' => 'Specify the percentage of discount the user will receive'
			],
			3 => [ // Buy X get cheapest free
				'label' => 'Number to buy',
				'displayInfo' => 'Specify how many qualifying products should be purchased before the cheapest item becomes free'
			],
			4 => [ // Buy X get cheapest half price
				'label' => 'Number to buy',
				'displayInfo' => 'Specify how many qualifying products should be purchased before the cheapest item becomes half price'
			],
			5 => [ // Free gift
				'visible' => false,
			],
			6 => [ // X for the price of Y
				'label' => 'Number to buy',
				'displayInfo' => '(X) Specify how many of the qualifying items should be purchased before the user only needs to pay for Y of them'
			],
			7 => [ // Free delivery
				'visible' => false
			],
			8 => [
				'label' => 'Number to buy',
				'displayInfo' => '(X) Specify how many of the qualifying items should be purchased to get them for the fixed price of Y',
			],
		]
	)
);
