<?php

class SaveFreeGiftDiscountsWithAnAmount extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_free_gift_discounts_with_an_amount';

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$DiscountCode = EvClassRegistry::init('EvDiscount.DiscountCode');
		$DiscountType = EvClassRegistry::init('EvDiscount.DiscountType');

		$freeGiftDiscountTypeId = $DiscountType->field(
			'id',
			[
				$DiscountType->alias . '.name' => 'Free gift',
			]
		);

		if (empty($freeGiftDiscountTypeId)) {
			debug("missing free gift discount type");
			return true;
		}

		$freeGiftDiscounts = $DiscountCode->find(
			'all',
			[
				'conditions' => [
					$DiscountCode->alias . '.discount_type_id' => $freeGiftDiscountTypeId,
				],
			]
		);

		if ($direction === 'down') {
			$freeGiftDiscounts = Hash::insert(
				$freeGiftDiscounts,
				'{n}.' . $DiscountCode->alias . '.amount',
				0
			);
		} else {
			$freeGiftDiscounts = Hash::insert(
				$freeGiftDiscounts,
				'{n}.' . $DiscountCode->alias . '.amount',
				1
			);
		}

		$discountCodeValidation = $DiscountCode->validate;
		$DiscountCode->validate = [];
		foreach ($freeGiftDiscounts as $freeGiftDiscount) {
			if ($direction === 'up') {
				$freeGiftDiscount[$DiscountCode->alias]['amount'] = 1;
			} else {
				$freeGiftDiscount[$DiscountCode->alias]['amount'] = null;
			}

			$DiscountCode->clear();
			$DiscountCode->save($freeGiftDiscount);
		}

		$DiscountCode->validate = $discountCodeValidation;

		return true;
	}
}
