<?php
class AddNewDiscountTypes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_new_discount_types';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$DiscountType = EvClassRegistry::init('EvDiscount.DiscountType');

		if ($direction == 'up') {
			$DiscountType->saveMany([
				[
					'DiscountType' => [
						'id' => 3,
						'name' => 'Buy X get cheapest free',
						'apply_to_items' => 1,
						'is_active' => 1
					],
				], [
					'DiscountType' => [
						'id' => 4,
						'name' => 'Buy X get cheapest half price',
						'apply_to_items' => 1,
						'is_active' => 1
					],
				], [
					'DiscountType' => [
						'id' => 5,
						'name' => 'Free gift',
						'apply_to_items' => 1,
						'is_active' => 1
					],
				], [
					'DiscountType' => [
						'id' => 6,
						'name' => 'X for the price of Y',
						'apply_to_items' => 1,
						'is_active' => 1
					],
				], [
					'DiscountType' => [
						'id' => 7,
						'name' => 'Free delivery',
						'apply_to_items' => 0,
						'is_active' => 1
					],
				]
			]);
		} else {
			$DiscountType->deleteAll([
				'id' => [3, 4, 5, 6, 7]
			]);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
