<?php
class AddApplyToItems extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_apply_to_items';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_discount_discount_types' => array(
					'apply_to_items' => array('type' => 'boolean', 'null' => false, 'default' => 0, 'after' => 'name'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_discount_discount_types' => array('apply_to_items'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$DiscountType = EvClassRegistry::init('EvDiscount.DiscountType');
			$DiscountType->query('UPDATE ev_discount_discount_types SET apply_to_items = 1 WHERE name = "percent"');
		}
		return true;
	}
}
