<?php
class MakeDiscountCodeRestrictionPolymorphic extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'make_discount_code_restriction_polymorphic';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_discount_code_restrictions' => array(
					'discount_model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4', 'after' => 'id'),
				),
			),
			'rename_field' => array(
				'ev_discount_code_restrictions' => array(
					'discount_code_id' => 'discount_model_id'
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_discount_code_restrictions' => array('discount_model'),
			),
			'rename_field' => array(
				'ev_discount_code_restrictions' => array(
					'discount_model_id' => 'discount_code_id'
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$CodeRestriction = EvClassRegistry::init('EvDiscount.CodeRestriction');
			$CodeRestriction->query('UPDATE ev_discount_code_restrictions SET discount_model = "DiscountCode"');
		}
		return true;
	}
}
