<?php
App::uses('CakeEventListener', 'Event');
App::uses('OrderStatus', 'EvCheckout.Model');

class DiscountListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Order.updateOrderTotal' => 'calculateDiscount',
			'Model.Order.orderCompleted' => 'discountApplied',
		);
	}

/**
 * Calculates an order discount.
 *
 * @param object $event
 * @return void
 */
	public function calculateDiscount(CakeEvent $event) {
		$data = &$event->data['Order'];

		$Order = ClassRegistry::init('EvCheckout.Order');
		$Order->id = $data['Order']['id'];
		$discountCode = $Order->field('discount_code');

		if (!empty($discountCode)) {

			$Discount = ClassRegistry::init('EvDiscount.Discount');

			$discount = $Discount->calculateDiscount($data, $discountCode);

			if ($discount > 0) {

				// Calculate average items VAT rate.
				$vatRate = ($data['Order']['vat'] - $data['Order']['delivery_vat'] - $data['Order']['surcharge_vat']) / $data['Order']['subtotal'];

				$data['Order']['discount_vat'] = $discount * $vatRate;
				$data['Order']['discount_total'] = $discount;
				$data['Order']['total'] -= round($discount + $data['Order']['discount_vat'], 2);

				$data['Order']['vat'] -= $discount * $vatRate;

			} else {

				// Remove the discount code from the order as it isn't supported.
				$data['Order']['discount_code'] = null;
				$data['Order']['discount_total'] = 0;

			}

		} else {

			// Remove the discount code from the order as it isn't supported.
			$data['Order']['discount_code'] = null;
			$data['Order']['discount_total'] = 0;

		}

		return;
	}

/**
 * Updates discount counter when a discount has been applied.
 *
 * @param object $event
 * @return void
 */
	public function discountApplied(CakeEvent $event) {
		$Discount = ClassRegistry::init('EvDiscount.Discount');
		$Order = ClassRegistry::init('EvCheckout.Order');

		$data = &$event->data['data'];

		if (!isset($data['Order']['discount_code'])) {
			$Order->id = $data['Order']['id'];
			$discountCode = $Order->field('discount_code');
		} else {
			$discountCode = $data['Order']['discount_code'];
		}

		if (!empty($discountCode)) {

			// Ensure that the order has only been flagged as completed once
			// before modifying the discount count (this checks we've not
			// been here before).
			$completedCount = $Order->OrderOrderStatusHistory->find(
				'count',
				array(
					'conditions' => array(
						'OrderOrderStatusHistory.order_id' => $data['Order']['id'],
						'OrderOrderStatusHistory.order_status_id' => OrderStatus::COMPLETED
					)
				)
			);

			if ($completedCount <= 1) {

				// Add to the discount usage count.
				$Discount->updateAll(
					array('Discount.uses' => 'Discount.uses + 1'),
					array('Discount.code' => $discountCode)
				);

			}

		}

		return;
	}

}
