# EvDiscount

## Installation

Simply add EvDiscount to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvDiscount`.

The installer will automatically setup the database tables and create a link within the admin menu to create discount codes.

## How it works

The discount plugin currently works based on the events system to trigger when a valid discount code has been added. If using within a standard E-Commerce setup everything is already in place, however if used outside of this some setup work will be needed.

Discount codes can be created at a fixed rate or a percentage amount, restrictions on the number of redemptions is currently **not implemented**, it was planned that this would use `EvInventory` functionality to manage this but never got round to it.

Cookies are also used to help track which codes a user has applied. Within the standard E-Commerce setup, these will be automatically cleared upon successful checkout via a listener listening for `EvCheckout.Controller.Order.success`.

## Setup 

Once installer has run, simply log into the admin to create any discount codes needed for the site.

Then within the templates, echo out the element that is bundled with `EvDiscount` to add a discount add form to the page.

	<?=$this->element('EvDiscount.Discounts/form')?>

If using outside of the standard EvCommerce setup, you will then need to create an Event listener to listen for `EvDiscount.Component.DiscountCodes.codeAdded`. This event is triggered when a valid code is added, within this listener you should then apply the discount code to your items. 

Within `EvBasket` is the listener for the basket plugin that applies the discount code to a customers basket so this can be used as a rough guide.

A library file also exists to aid in the calculation of the discount code, simply pass the Discount Code array from the database to it along with the sub total we are calculating the discount on.

	App::uses('DiscountLib', 'EvDiscount.Lib');
	
	$code = $DiscountModel->readForEdit(1);
	$basketTotal = 10.50;
		
	$discountAmount = DiscountLib::calculate($code, $basketTotal);

If used in a custom scenario, you will also need to make sure any discount cookies are cleared upon checkout or purchase of the discounted items.

The following is the `clearCookie` method from the listener which handles the clearing of cookies upon processing `EvCheckout.Controller.Order.success` event.

	/**
	 * clear the cookie
	 *
	 * @param 	CakeEvent
	 */
	public function clearCookie(CakeEvent $Event) {
		// Event Subject sghould be controller
		$EventSubject = $Event->subject();

		// try to load the discount cookie
		if (empty($EventSubject->DiscountCookie)) {
			$EventSubject->DiscountCookie = $EventSubject->loadComponent('EvDiscount.DiscountCookie');
		}

		$EventSubject->DiscountCookie->delete('Code');

		return true;
	}

## Events

### EvDiscount.Component.DiscountCodes.codeAdded

When a discount code has been successfully validated, this event is triggered. Your code will need to listen for this event and then apply as needed.

EvBasket comes with this listener built in if EvDiscount is detected, this listener will take the code and check any code restrictions are met (correct protects are in the basket) and that the min order is met.

#### Parameters

* `code` - The actual code used
* `data` - Full data array of the code and code restrictions
