<?php

App::uses('CakeEventListener', 'Event');

class EvDiscountClearCookieListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'clearCookie'
		);
	}

	/**
	 * clear the cookie and increment the discount code usage
	 *
	 * @param 	CakeEvent
	 */
	public function clearCookie(CakeEvent $Event) {
		// Event Subject sghould be controller
		$EventSubject = $Event->subject();

		// try to load the discount cookie
		if (empty($EventSubject->DiscountCookie)) {
			$EventSubject->DiscountCookie = $EventSubject->loadComponent('EvDiscount.DiscountCookie');
		}

		// Retrieve discount code details from the cookie data
		$discountModel = EvClassRegistry::init('EvDiscount.DiscountCode');
		$disountData = $EventSubject->DiscountCookie->read();

		if (! empty($discountData)) {
			$discountData = $discountModel->decryptHash($discountData);
		}

		if (isset($discountData['id']) && $discountData['id'] > 0) {
			// Discount code was found. Now we need to increment its total uses
			$discountModel->increaseTimesUsed($discountData['id']);
		}


		$EventSubject->DiscountCookie->delete('Code');

		return true;
	}

}
