<?php

class DiscountLib {

	const AMOUNT_DISCOUNT = 1;
	const PERCENTAGE_DISCOUNT = 2;

	/**
	 * calculate the discount amount
	 *
	 * @param 	array 	$codeData 	The code data we are calculating
	 * @param 	float 	$subtotal 	The subtotal amount to calculate percentages off
	 * @return 	float 	$amount 	The discount amount
	 */
	public static function calculate($codeData, $subtotal) {
		if (empty($codeData['DiscountCode']['amount']) || $codeData['DiscountCode']['amount'] == '0.000000') {
			return 0;
		}

		$amount = 0;
		if ($codeData['DiscountCode']['discount_type_id'] == DiscountLib::AMOUNT_DISCOUNT) {
			// fixed amount, just return it

			$amount = $codeData['DiscountCode']['amount'];
		} elseif ($codeData['DiscountCode']['discount_type_id'] == DiscountLib::PERCENTAGE_DISCOUNT) {
			// percentage, work it out

			$amount = ($codeData['DiscountCode']['amount'] / 100) * $subtotal;
		}

		return $amount;
	}
}
