<?php

App::uses('EvDiscountAppController', 'EvDiscount.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class DiscountCodesController extends EvDiscountAppController {

	/**
	 * disable filters
	 */
	protected function _adminFilterFields() {
		return array();
	}

	/**
	 * add code field to columns
	 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$columns = ArrayUtil::addAfter(
			$columns,
			'DiscountCode.name',
			array(
				'DiscountCode.code' => array(
					'type' => 'string',
					'label' => __('Code')
				)
			)
		);

		return $columns;
	}

	/**
	 * populate the lookups
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$this->set(
			'discountTypes',
			$this->DiscountCode->DiscountType->getForDropdown()
		);
	}

	/**
	 * form fields
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['DiscountCode.discount_type_id']['class'] = 'discount-type';
		$fields['DiscountCode.amount']['class'] = 'discount-amount';
		$fields['DiscountCode.min_order']['label'] = 'Min Order &pound;';

		$fields['DiscountCode.times_used']['info'] = 'This value will automatically increase by one each time the code is used';
		$fields['DiscountCode.maximum_uses']['info'] = 'If this value is set to greater than zero, that will be the maximum number of times this code can be used.';

		return $fields;
	}

	/**
	 * redefine admin_edit
	 */
	public function admin_edit($id = null) {
		$this->toInject('components', 'EvDiscount.CodeRestrictions');
		$this->toInject('helpers', 'EvDiscount.CodeRestrictions');

		parent::admin_edit($id);

		$this->view = 'EvDiscount.DiscountCodes/admin_form';
	}
}
