<?php

App::uses('EvDiscountAppController', 'EvDiscount.Controller');

class CodeRestrictionsController extends EvDiscountAppController {

	/**
	 * given the model name, loadit up and get the items
	 *
	 * @param 	string 	$modelName 	The model to load
	 * @return 	json
	 */
	public function ajax_getModelItems($modelName) {
		if (! empty($modelName)) {
			$Model = EvClassRegistry::init($modelName);

			$params = array();

			if ($Model->hasField('title')) {
				$params['order'] = $Model->alias . '.title ASC';
			} elseif ($Model->hasField('name')) {
				$params['order'] = $Model->alias . '.name ASC';
			}

			$items = $Model->getForDropDown($params);

			/*
				simply flipping the array does not work as some of the products could have integer
				values, which causes array_flip to complain. To get around this the array needs to
				be manually created.
			*/
			$body = array();

			foreach ($items as $id => $name) {
				if (! empty($name) && ! empty($id)) {
					$body[$name] = $id;
				}
			}

		} else {
			$body = array();
		}

		$this->response->type('json');
		$this->response->disableCache();
		$this->response->body(
			json_encode(
				$body
			)
		);
		return $this->response;
	}

}
