<?php

App::uses('CakeEventListener', 'Event');

class EvDiscountClearCookieListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'clearCookie'
		);
	}

	/**
	 * clear the cookie
	 *
	 * @param 	CakeEvent
	 */
	public function clearCookie(CakeEvent $Event) {
		// Event Subject sghould be controller
		$EventSubject = $Event->subject();

		// try to load the discount cookie
		if (empty($EventSubject->DiscountCookie)) {
			$EventSubject->DiscountCookie = $EventSubject->loadComponent('EvDiscount.DiscountCookie');
		}

		$EventSubject->DiscountCookie->delete('Code');

		return true;
	}

}
