<?php

class DiscountLib {

	/**
	 * calculate the discount amount
	 *
	 * @param 	array 	$codeData 	The code data we are calculating
	 * @param 	float 	$subtotal 	The subtotal amount to calculate percentages off
	 * @return 	float 	$amount 	The discount amount
	 */
	public static function calculate($codeData, $subtotal) {
		if (empty($codeData['DiscountCode']['amount']) || $codeData['DiscountCode']['amount'] == '0.000000') {
			return 0;
		}

		$amount = 0;
		if ($codeData['DiscountCode']['discount_type_id'] == 1) {
			// fixed amount, just return it

			$amount = $codeData['DiscountCode']['amount'];
		} elseif ($codeData['DiscountCode']['discount_type_id'] == 2) {
			// percentage, work it out

			$amount = ($codeData['DiscountCode']['amount'] / 100) * $subtotal;
		}

		return $amount;
	}
}
