<?php

App::uses('AppComponent', 'Controller/Component');

class DiscountCodesComponent extends AppComponent {

	/**
	 * Component startup - check for the form being submitted
	 *
	 */
	public function startup(Controller $Controller) {
		if ($this->_controller->request->is('post') && ! empty($this->_controller->request->data['Discount'])) {
			$this->_setupCookie();
			$discountCookie = $this->_controller->DiscountCookie->read('Code');

			if (! empty($discountCookie) && Configure::read('EvDiscount.multipleCodes') !== true) {
				$this->_controller->Flash->fail(
					__('A discount code has already been applied'),
					array(
						'key' => 'discount-flash'
					)
				);

				return false;
			}

			$code = $this->_controller->request->data['Discount']['DiscountCode']['code'];

			$DiscountCode = EvClassRegistry::init('EvDiscount.DiscountCode');
			$data = $DiscountCode->getCode($code);

			if (empty($data)) {
				$this->_controller->Flash->fail(
					__('The code entered is not valid'),
					array(
						'key' => 'discount-flash'
					)
				);

				return false;
			}

			// hash teh code
			$hash = $DiscountCode->hashForCookie($data);

			$this->_controller->DiscountCookie->write('Code.' . $code, $hash);

			// dispatch event
			$this->_controller->getEventManager()->dispatch(
				new CakeEvent('EvDiscount.Component.DiscountCodes.codeAdded', $this, array(
					'code' => $code,
					'data' => $data
				))
			);

			$this->_controller->Flash->success(
				__('Discount code applied'),
				array(
					'key' => 'discount-flash'
				)
			);
		}

		return true;
	}

	/**
	 * setup the discount cookie
	 */
	protected function _setupCookie() {
		if (empty($this->_controller->DiscountCookie)) {
			$this->_controller->DiscountCookie = $this->_controller->loadComponent('EvDiscount.DiscountCookie');
		}
	}

}
