<?php

App::uses('EvDiscountAppController', 'EvDiscount.Controller');

class CodeRestrictionsController extends EvDiscountAppController {

	/**
	 * given the model name, loadit up and get the items
	 *
	 * @param 	string 	$modelName 	The model to load
	 * @return 	json
	 */
	public function ajax_getModelItems($modelName) {
		if (! empty($modelName)) {
			$Model = EvClassRegistry::init($modelName);

			$params = array();

			if ($Model->hasField('title')) {
				$params['order'] = $Model->alias . '.title ASC';
			} elseif ($Model->hasField('name')) {
				$params['order'] = $Model->alias . '.name ASC';
			}

			$body = $Model->getForDropDown($params);

			/*
				due to crazy chrome bug, which resorts any json arrays with numerical keys.
				we flip the array and then handle in the js to preserve the order
			*/
			$body = array_flip($body);

		} else {
			$body = array();
		}

		$this->response->type('json');
		$this->response->disableCache();
		$this->response->body(
			json_encode(
				$body
			)
		);
		return $this->response;
	}

}
