<?php

class DiscountTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.ev_discount.discount',
		'plugin.ev_discount.brands_discount',
		'plugin.ev_discount.discounts_product',
		'plugin.ev_discount.ev_discount_related_item'
	);

	public function setUp() {
		parent::setUp();
		$this->Discount = ClassRegistry::init('EvDiscount.Discount');
	}

	public function testCalculate() {
		$result = $this->Discount->calculate(10, 20, 1);
		$this->assertEquals(2, $result);
	}

	public function testCalculateDiscount() {
		$data = $this->_testData();

		// Test £10 discount (excludes VAT so should equal 8.33).
		$result = $this->Discount->calculateDiscount($data, 'tenpounds');
		$this->assertEquals(8.33, $result);

		// Test % discounts.
		$result = $this->Discount->calculateDiscount($data, 'thirdoff');
		$this->assertEquals(5, round($result, 2));

		$result = $this->Discount->calculateDiscount($data, '10percent');
		$this->assertEquals(1.5, round($result, 2));
	}

	public function testCalculateBrandDiscount() {
		$data = $this->_testData();

		$result = $this->Discount->calculateDiscount($data, 'branded');
		$this->assertEquals(1.0, round($result, 2));
	}

	public function testCalculateProductDiscount() {
		$data = $this->_testData();

		$result = $this->Discount->calculateDiscount($data, 'product');
		$this->assertEquals(0.5, round($result, 2));
	}

	public function testCalculateProductAndBrandDiscount() {
		$data = $this->_testData();

		// Test that a product-brand specific discount must match both
		// products and brands.
		$result = $this->Discount->calculateDiscount($data, 'product-brand');
		$this->assertEquals(0, round($result, 2));

		$result = $this->Discount->calculateDiscount($data, 'product-brand2');
		$this->assertEquals(1.0, round($result, 2));
	}

	protected function _testData() {
		return array(
			'Order' => array(
				'subtotal' => 15
			),
			'OrderItem' => array(
				array(
					'id' => 1,
					'product_id' => 1,
					'subtotal' => 10
				),
				array(
					'id' => 2,
					'product_id' => 2,
					'subtotal' => 5
				)
			)
		);
	}

}
