<?php

App::uses('EvDiscountAppController', 'EvDiscount.Controller');

class DiscountsController extends EvDiscountAppController {

	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		$fields["{$Model->alias}.discount_type_id"]['empty'] = false;

		// Removed the uses column, this shouldn't be directly edited.
		unset($fields["{$Model->alias}.uses"]);

		$newFields = array(
			'Brand.Brand' => array(
				'type' => 'multiselect'
			),
			'Product.Product' => array(
				'type' => 'multiselect'
			)
		);

		$fields = ArrayUtil::addAfter($fields, 'Discount.max_uses', $newFields);

		return $fields;
	}

	protected function _adminPopulateLookups() {
		$Model = $this->{$this->modelClass};

		$brands = $Model->Brand->find(
			'list',
			array(
				'order' => array(
					'Brand.name' => 'ASC'
				)
			)
		);
		$products = $Model->Product->find(
			'list',
			array(
				'order' => array(
					'Product.name' => 'ASC'
				)
			)
		);

		$this->set('discountTypes', $Model->DiscountType->find('list'));
		$this->set(compact('brands', 'products'));

		return;
	}

}
