<?php
class CreatedDiscountTypesTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = '';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'ev_discount_discount_types' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
			'create_field' => array(
				'ev_discount_discounts' => array(
					'discount_type_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index', 'after' => 'code'),
					'indexes' => array(
						'discount_type_id' => array('column' => 'discount_type_id', 'unique' => 0),
					),
				),
			),
			'drop_field' => array(
				'ev_discount_discounts' => array('type',),
			),
		),
		'down' => array(
			'drop_table' => array(
				'ev_discount_discount_types'
			),
			'drop_field' => array(
				'ev_discount_discounts' => array('discount_type_id', 'indexes' => array('discount_type_id')),
			),
			'create_field' => array(
				'ev_discount_discounts' => array(
					'type' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction, up or down direction of migration process
 * @return boolean Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction, up or down direction of migration process
 * @return boolean Should process continue
 */
	public function after($direction) {

		$DiscountType = ClassRegistry::init('EvDiscount.DiscountType');

		$data = array(
			array(
				'id' => 1,
				'name' => 'Percentage'
			),
			array(
				'id' => 2,
				'name' => 'Fixed'
			)
		);

		$DiscountType->saveMany($data);

		return true;
	}
}
