<?php
/**
 * Settings and shortcuts common to all of our projects
 */

namespace Deployer;

set('git_tty', false);
set('http_group', 'www-data');
set('http_user', 'www-data');
set('allow_anonymous_stats', false);
set('writable_mode', 'chmod');
set('writable_chmod_recursive', true);
set('writable_chmod_mode', '777');

if (!empty(getenv('CI_PROJECT_NAME')) && !empty(getenv('CI_COMMIT_REF_SLUG'))) {
    set('application_name', sprintf('%s-%s', getenv('CI_PROJECT_NAME'), getenv('CI_COMMIT_REF_SLUG')));
}

if (!empty(get('php_version'))) {
    set('bin/php', '/usr/bin/php' . get('php_version'));
}

after('deploy:failed', 'deploy:unlock');
