<?php

namespace Tests\Unit;

use PHPUnit\Framework\TestCase;
use function Evoluted\Deployer\Db\getDatabaseName;
use function Evoluted\Deployer\Db\shortenDatabaseName;

class DatabaseTest extends TestCase
{
    /**
     * @dataProvider getNameProvider
     */
    public function testGetName(string $project, string $branch, string $application, string $prefix, string $expectedName, string $type): void
    {
        $name = getDatabaseName($project, $branch, $application, $prefix, $type);
        $this->assertSame($name, $expectedName);
    }

    public function getNameProvider(): array
    {
        return [
            'mysql empty' => [ '', '' , '', '', '_', 'mysql' ],
            'pgsql empty' => [ '', '' , '', '', '_', 'postgresql' ],
            'mysql short, no app, no prefix' => [ 'project', 'branch', '', '', 'project_branch', 'mysql' ],
            'pgsql short, no app, no prefix' => [ 'project', 'branch', '', '', 'project_branch', 'postgresql' ],
            'mysql short, no app' => [ 'project', 'branch', '', 'prefix_', 'prefix_project_branch', 'mysql' ],
            'pgsql short, no app' => [ 'project', 'branch', '', 'prefix_', 'prefix_project_branch', 'postgresql' ],
            'mysql short' => [ 'project', 'branch', 'app', 'prefix_', 'prefix_project_app_branch', 'mysql' ],
            'pgsql short' => [ 'project', 'branch', 'app', 'prefix_', 'prefix_project_app_branch', 'postgresql' ],
            'mysql long' => [
                'decorative_aggregates',
                'feature-collection-orders',
                'colouredquartz',
                'cd_',
                'cd_decorative_aggregates_2su1v2m_feature_collection_orders',
                'mysql',
            ],
            'pgsql long' => [
                'decorative_aggregates',
                'feature-collection-orders',
                'colouredquartz',
                'cd_',
                'cd_decorative_aggregates_2su1v2m_feature_collection_orders',
                'postgresql',
            ],
        ];
    }

    /**
     * @dataProvider shortenDatabaseNameProvider
     */
    public function testShortenDatabaseName(string $inputName, string $project, string $branch, string $prefix, string $expectedOutputName, string $type): void
    {
        $name = shortenDatabaseName($inputName, $project, $branch, $prefix, $type);
        $this->assertSame($name, $expectedOutputName);
    }

    public function shortenDatabaseNameProvider(): array
    {
        return [
            'mysql empty' => [ '', '', '', '', '', 'mysql' ],
            'pgsql empty' => [ '', '', '', '', '', 'postgresql' ],
            'mysql short' => [ 'a', 'b', 'c', 'd', 'a', 'mysql' ],
            'pgsql short' => [ 'a', 'b', 'c', 'd', 'a', 'postgresql' ],
            'mysql not long enough' => [
                'cd_premier_products_ecommerce_feature_admin_frontend',
                'premier_products_ecommerce',
                'feature-admin-frontend',
                'cd_',
                'cd_premier_products_ecommerce_feature_admin_frontend',
                'mysql',
            ],
            'pgsql not long enough' => [
                'cd_premier_products_ecommerce_feature_admin_frontend',
                'premier_products_ecommerce',
                'feature-admin-frontend',
                'cd_',
                'cd_premier_products_ecommerce_feature_admin_frontend',
                'postgresql',
            ],
            'mysql long' => [
                'cd_decorative_aggregates_colouredquartz_feature_collection_orders',
                'decorative_aggregates',
                'feature-collection-orders',
                'cd_',
                'cd_decorative_aggregates_2su1v2m_feature_collection_orders',
                'mysql',
            ],
            'pgsql long' => [
                'cd_decorative_aggregates_colouredquartz_feature_collection_orders',
                'decorative_aggregates',
                'feature-collection-orders',
                'cd_',
                'cd_decorative_aggregates_2su1v2m_feature_collection_orders',
                'postgresql',
            ],
        ];
    }
}