<?php

namespace Tests\Integration;

use PHPUnit\Framework\TestCase;
use function Evoluted\Deployer\Db\createDatabase;
use function Evoluted\Deployer\Db\databaseExists;
use function Evoluted\Deployer\Db\dropDatabase;
use function Evoluted\Deployer\Db\getDatabaseConnection;

class MySqlTest extends TestCase
{
    private $db;

    protected function setUp(): void
    {
        $host = getenv('DB_HOST');
        $username = getenv('DB_USERNAME');
        $password = getenv('DB_PASSWORD');

        $this->db = getDatabaseConnection($host, $username, $password, 'mysql');
    }

    public function testExists(): void
    {
        $this->assertTrue(databaseExists($this->db, 'information_schema'));
    }

    public function testCreate(): void
    {
        $this->assertFalse(databaseExists($this->db, 'deployer_recipe_test_create'));
        $this->assertTrue(createDatabase($this->db, 'deployer_recipe_test_create'));
        $this->assertTrue(databaseExists($this->db, 'deployer_recipe_test_create'));
    }

    /**
     * @depends testCreate
     */
    public function testDrop(): void
    {
        $this->assertTrue(databaseExists($this->db, 'deployer_recipe_test_create'));
        $this->assertTrue(dropDatabase($this->db, 'deployer_recipe_test_create'));
        $this->assertFalse(databaseExists($this->db, 'deployer_recipe_test_create'));
    }
}