<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * General Evoluted Helper tasks
 *
 */
namespace Deployer;

desc('Compile assets using Yarn for production');
task('yarn:compile', function () {
	run('cd {{release_path}} && yarn install && yarn run prod');
});

// General helper functions


/**
 * Generates the slug unique to the project and environment
 * @return [type] [description]
 */
function cdEnvironmentSlug() {
    $slug = getenv('CI_PROJECT_NAME');
    if (getenv('APPLICATION_PREFIX')) {
        $slug .= '-' . getenv('APPLICATION_PREFIX');
    }
    $slug .= '-' . getenv('CI_BUILD_REF_SLUG');

    return $slug;
}

/**
 * For legacy applications application_type includes the application type and the PHP version
 * This function splits it out into the separate components if we need them
 *
 * @param string $applicationType E.g. "laravel72", "cake70"
 */
function splitApplicationType($applicationType) {
    $matches = null;
    if (preg_match('/([a-z]+)([0-9]+)/', $applicationType, $matches)) {
        $applicationType = $matches[1];
        // Split the php version into subversion 72 => 7.2
        $phpVersion = substr($matches[2], 0, 1) . "." . substr($matches[2], 1);
    }

    return [
        'applicationType' => $applicationType,
        'phpVersion' => $phpVersion
    ];
}
