<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Supoervisord tasks
 *
 */
namespace Deployer;

require_once 'general.php';

task('supervisor:configure', function() {
    // Read in supervisor template in
    if (file_exists('./supervisor-jobs.template')) {
        $supervisorTemplate = file_get_contents('./supervisor-jobs.template');
        $supervisorContents = parse($supervisorTemplate);
        // Create supervisor config file from tempalte and add to server
        run('echo "' . $supervisorContents . '" > ' . get('release_path') . "/.supervisor-jobs");
        $slug = cdEnvironmentSlug();
        run("sudo symlink-supervisor {{release_path}}/.supervisor-jobs $slug");

        // Create the log file as the deploy user otherwise supervisor creates it as root and makes changing it difficult
        run("touch {{release_path}}/storage/logs/worker.log");

        invoke('supervisor:reloadconfig');
    }
});

task('supervisor:reloadconfig', function() {
    $slug = cdEnvironmentSlug();

    // Re-read in the config, update any changed configs and start supervisor for this application incase it hasn't already been
    run("sudo supervisorctl reread && sudo supervisorctl update && sudo supervisorctl start " . $slug . "-worker:*");
});

task('supervisor:destroy', function() {
    $slug = cdEnvironmentSlug();
    run("sudo remove-supervisor " . $slug);
})->desc('Destroys supervisor file for project');


