<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Deployer;

require 'recipe/laravel.php';

add('shared_files', []);
add('shared_dirs', [
	'public/app/evoluted',
	'public/assets/thinktank',
	'public/assets/img/news'
]);
add('writable_dirs', [
	'public/app/evoluted',
	'public/assets',
	'storage'
]);

task('artisan:config:cache', function () {
	// Do nothing, as there is an issue on one of the
	// symfony packages that uses a closure in the cache
});

desc('Compile PyroCMS stream classes and migrations');
task('pyrocms:streams:compile', function () {
	run("sed -i 's/INSTALLED=true/INSTALLED=false/g' {{release_path}}/.env");
	run('{{bin/php}} {{release_path}}/artisan streams:compile');
	run('{{bin/php}} {{release_path}}/artisan migrate --force --streams');
	run('{{bin/php}} {{release_path}}/artisan migrate --force');
	run('{{bin/php}} {{release_path}}/artisan migrate --force --all-addons');
	run('{{bin/php}} {{release_path}}/artisan twig:clear');
	run("sed -i 's/INSTALLED=false/INSTALLED=true/g' {{release_path}}/.env");
});

desc('Run migrations for ALL addons');
task('pyrocms:migrations:all-addons', function () {
    run('{{bin/php}} {{release_path}}/artisan migrate --all-addons');
});

desc('Placeholder for the start of application deployment');
task('deploy:init', function () {
});

/**
 * Main task
 */
desc('Deploy your project');
task('deploy', [
	'deploy:info',
	'deploy:prepare',
	'deploy:lock',
	'deploy:release',
	'deploy:update_code',
	'deploy:shared',
	'deploy:vendors',
	'deploy:writable',
	'deploy:init',
	'pyrocms:streams:compile',
	'artisan:migrate',
	'pyrocms:migrations:all-addons',
	'artisan:storage:link',
	'artisan:view:clear',
	'artisan:cache:clear',
	'artisan:config:cache',
	'artisan:optimize',
	'deploy:symlink',
	'deploy:unlock',
	'cleanup',
]);
after('deploy', 'success');
