<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * General Evoluted Helper tasks
 *
 */
namespace Deployer;

desc('Compile assets using Yarn for production');
task('yarn:compile', function () {
	run('cd {{release_path}} && yarn install && yarn run prod');
});

// General helper functions 
 

/**
 * Generates the slug unique to the project and environment
 * @return [type] [description]
 */
function cdEnvironmentSlug() {
    $slug = getenv('CI_PROJECT_NAME');
    if (getenv('APPLICATION_PREFIX')) {
        $slug .= '-' . getenv('APPLICATION_PREFIX');
    }
    $slug .= '-' . getenv('CI_COMMIT_REF_SLUG');

    return $slug;
}