<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Deployer;

require 'recipe/common.php';

set('shared_dirs', [
	'app/webroot/files',
	'app/tmp/queue',
	'app/tmp/logs',
	'app/tmp/sessions'
]);

set('shared_files', [
	'app/tmp/dynamic_routes.php',
	'app/tmp/temp_dynamic_routes.php'
]);

set('writable_dirs', [
	'app/webroot/files',
	'app/tmp/cache',
	'app/tmp/logs',
	'app/tmp/queue',
	'app/tmp/sessions',
	'app/tmp/rate_limiting'
]);

/**
 * Create plugins' symlinks
 */
task('deploy:init', function () {
	run('chmod +x {{release_path}}/app/Console/cake');
})->desc('Initialization');

task('deploy:link_plugins', function () {
	run('cd {{release_path}}/app && Console/cake ln all force');
})->desc('Link Cakephp plugin assets into the webroot');

/**
 * Run migrations
 */
task('deploy:run_migrations', function () {
	run('cd {{release_path}}/app && Console/cake installer migrate');
})->desc('Run migrations');

task('deploy:setup_routes', function () {
	run('cd {{release_path}}/app && Console/cake Routable.Routes rebuild');
	run('cd {{release_path}}/app && Console/cake Queue.queue runworker');
})->desc('Set up routes');

task('deploy:rebuild_permissions', function () {
	run('cd {{release_path}}/app && Console/cake EvCore.Permissions sync -u');
})->desc('Rebuild the ACL permissions');

// task('deploy:prepare', function() {
	// $task->createFolder('shared/app/tmp/cache/persistent', true);
	// $task->createFolder('shared/app/tmp/cache/models');
	// $task->createFolder('shared/app/tmp/cache/views');
	// $task->createFolder('shared/app/tmp/logs', true);
	// $task->createFolder('shared/app/tmp/sessions');
	// $task->createFolder('shared/app/tmp/tests');
	// $task->createFolder('shared/app/webroot/files', true);
	// $task->run((array)$setPermissions($task, $task->paths->getFolder('shared/app/webroot/files/')));
// });
/**
 * Main task
 */
task('deploy', [
	'deploy:info',
	'deploy:prepare',
	'deploy:lock',
	'deploy:release',
	'deploy:update_code',
	'deploy:shared',
	'deploy:writable',
	'deploy:vendors',
	'deploy:init',
	'deploy:link_plugins',
	'deploy:run_migrations',
	'deploy:setup_routes',

	'deploy:symlink',
	'deploy:unlock',
	'cleanup',
])->desc('Deploy your project');
after('deploy', 'success');
