<?php

namespace Deployer;

set('gitlabAccessToken', 'xHy-B-1JvspdZBh_2jUz');
set('gitlabDomain', 'https://git.evoluted.net');
set('gitlabApiUrl', 'api/v4');
set('gitlabArtifactStage', 'store'); //The name of the stage the artifact to deploy from is stored against.

//Upload gitlab artifact
task(
	'ci:setup:upload',
	function () {
		//Make a curl request to the gitlab api for the jobs on the current pipeline
		$curlPipelineJobs = curl_init();

		//Set the url, only get successfuly jobs.
		$pipelineJobsUrl = sprintf(
			'%s/%s/projects/%s/pipelines/%s/jobs?scope=success',
			get('gitlabDomain'),
			get('gitlabApiUrl'),
			getenv('CI_PROJECT_ID'),
			getenv('CI_PIPELINE_ID')
		);

		curl_setopt_array(
			$curlPipelineJobs,
			[
				CURLOPT_URL => $pipelineJobsUrl,
				CURLOPT_HTTPHEADER => [ //Set custom http headers
					'PRIVATE-TOKEN: ' . get('gitlabAccessToken'),
				],
				CURLOPT_RETURNTRANSFER => true, //Set the option to return the response instead of success/failure.
				CURLOPT_CONNECTTIMEOUT => 60, //Maximum number of seconds to wait to make a connection to gitlab. 1 minute.
				CURLOPT_TIMEOUT => 300, //Maximum number of seconds to wait for the curl request to complete. 5 minutes.
			]
		);

		//Perform the curl request
		$pipelineJobs = curl_exec($curlPipelineJobs);

		//Close the curl request as we are done.
		curl_close($curlPipelineJobs);

		$pipelineJobs = json_decode($pipelineJobs);

		/*
		 * Loop through the jobs on the current pipeline by most recent first and find the stage that stores the
		 * artifact to deploy with.
		 */
		$artifactUploaded = false;
		foreach ($pipelineJobs as $job) {
			if ($job->stage != get('gitlabArtifactStage')) {
				continue;
			}

			//Build the url the artifact will come from.
			$artifactUrl = sprintf(
				'%s/%s/projects/%s/jobs/%s/artifacts',
				get('gitlabDomain'),
				get('gitlabApiUrl'),
				getenv('CI_PROJECT_ID'),
				$job->id
			);

			//Build the location the artifact will be uploaded to.
			$releaseFile = get('release_path') . '/artifact.zip';

			//Perform a curl request on the server being deployed to to download the artifact.
			run('curl --location --output ' . $releaseFile . ' --header "PRIVATE-TOKEN: ' . get('gitlabAccessToken') . '" ' . $artifactUrl);

			//Unzip the artifact
			run('unzip -o -q ' . $releaseFile . ' -d ' . get('release_path'));

			//Remove the artifact as it is no longer needed.
			run('rm ' . $releaseFile);

			$artifactUploaded = true;
			break;
		}

		if (!$artifactUploaded) {
			//Generate browse url for when the artifact can't be found.
			$artifactBrowseUrl = sprintf(
				'%s/%s/-/jobs/%s/artifacts/browse',
				get('gitlabDomain'),
				getenv('CI_PROJECT_PATH_SLUG'),
				getenv('CI_JOB_ID')
			);

			throw new RuntimeException(
				Context::get()->getHost()->getHostname(),
				'ci:setup:upload',
				null,
				'Artifact was not uploaded. Check the store job was successfully run and that an artifact exists: ' . $artifactBrowseUrl,
				null
			);
		}
	}
);
after('deploy:update_code', 'ci:setup:upload');
