<?php
/**
 * Set AWS as the production host
 *
 * So doing `dep deploy production` will go to AWS
 */

namespace Deployer;

return host('aws1.core.evoluted.net', 'aws2.core.evoluted.net', 'aws3.core.evoluted.net')
    ->user(get('aws_user', 'deploy'))
    ->stage('production')
    ->set('branch', get('live_branch', 'master'))
    ->set('deploy_path', '/var/www/vhosts/' . get('application_name') . '/production')
    ->set('http_user', get('aws_user', 'deploy'))
    ->set('http_group', 'www-data')
    ->set('keep_releases', 5)
;
