<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Crontab Management
 *
 */
namespace Deployer;

require_once 'general.php';

task('crontab:update', function () {
	$selectedStage = Deployer::get()->getInput()->getArgument('stage');
	$cronPaths = [
		get('release_path') . '/crontab.' . getenv('CI_COMMIT_REF_SLUG') . '.template',
		get('release_path') . '/supervisor-jobs.' . $selectedStage . '.template',
		get('release_path') . '/crontab.template',
	];
	if (getenv('APPLICATION_PREFIX')) {
		// If there's an application prefix prioritise that
		array_unshift($cronPaths, get('release_path') . '/crontab.' . getenv('CI_COMMIT_REF_SLUG') . '-' . getenv('APPLICATION_PREFIX') . '.template');
	}

	$cronPath = current($cronPaths);
	writeln('<info>Looking for deploy specific crontab template at "' . $cronPath . '"</info>');
	while (!empty($cronPath) && run('if [ -f "' . $cronPath . '" ]; then echo "Y"; else echo "N"; fi') === 'N') {
		$cronPath = next($cronPaths);
		if (!empty($cronPath)) {
			writeln('<info>Looking for deploy specific crontab template at "' . $cronPath . '"</info>');
		} else {
			writeln('<info>No crontab template found</info>');
		}
	}

    // Read in crontab template in
    if (!empty($cronPath)) {
        $crontabTemplate = run('cat "' . $cronPath . '"');
        $crontabContents = parse($crontabTemplate);
        // Add .crontab file to deployment
        run('echo "' . base64_encode($crontabContents) . '" | base64 -d > ' . get('release_path') . "/.crontab");

        $slug = cdEnvironmentSlug();

        run("sudo symlink-crontab {{release_path}}/.crontab " . $slug);
    }
})->desc('Create crontab file and install')->onStage('cd');

task('crontab:destroy', function () {
	$slug = cdEnvironmentSlug();
    run('sudo remove-crontab ' . $slug);
})->desc('Destroys crontab file for project')->onStage('cd');
