<?php

namespace Deployer;

require 'recipe/common.php'; // application type should come before

// Setup steps
desc('Deploy your project');
task('deploy', [
    'deploy:info',
    'deploy:prepare',
    'deploy:lock',
    'deploy:release',
    'deploy:update_code',
    'deploy:shared',
    'deploy:writable',
    'deploy:vendors',
    'deploy:init',
    'craft:migrate',
    'deploy:clear_paths',
    'deploy:symlink',
    'deploy:unlock',
    'cleanup',
]);

after('deploy', 'success');

set('shared_files', [
    '.env'
]);
set('shared_dirs', [
    'storage',
]);
set('writable_dirs', [
    'storage',
    'storage/runtime',
    'storage/logs',
    'storage/rebrand',
    'public/cpresources'
]);

desc('Execute migrations');
task('craft:migrate', function () {
    run('{{bin/php}} {{release_path}}/craft migrate/all --no-content --interactive=0 --no-backup');
    run('{{bin/php}} {{release_path}}/craft project-config/apply --force');
    run('{{bin/php}} {{release_path}}/craft migrate --track=content --interactive=0');
    // This should silently fail if the table already exists
    run('{{bin/php}} {{release_path}}/craft setup/php-session-table');
})->once();
