<?php
/* (c) Sam Biggins <sam@evoluted.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Supoervisord tasks
 *
 */
namespace Deployer;

require_once 'general.php';

task('supervisor:configure', function() {
	$selectedStage = Deployer::get()->getInput()->getArgument('stage');
	$supervisorTemplates = [
		get('release_path') . '/supervisor-jobs.' . getenv('CI_COMMIT_REF_SLUG') . '.template',
		get('release_path') . '/supervisor-jobs.' . $selectedStage . '.template',
		get('release_path') . '/supervisor-jobs.template',
	];
	if (getenv('APPLICATION_PREFIX')) {
		// If there's an application prefix prioritise that
		array_unshift($supervisorTemplates, get('release_path') . '/supervisor-jobs.' . getenv('CI_COMMIT_REF_SLUG') . '-' . getenv('APPLICATION_PREFIX') . '.template');
	}

	$supervisorTemplate = current($supervisorTemplates);
	writeln('<info>Looking for deploy specific supervisor-jobs template at "' . $supervisorTemplate . '"</info>');
	while (!empty($supervisorTemplate) && run('if [ -f "' . $supervisorTemplate . '" ]; then echo "Y"; else echo "N"; fi') === 'N') {
		$supervisorTemplate = next($supervisorTemplates);
		if (!empty($supervisorTemplate)) {
			writeln('<info>Looking for deploy specific supervisor-jobs template at "' . $supervisorTemplate . '"</info>');
		} else {
			writeln('<info>No supervisor-jobs template found</info>');
		}
	}
	// Read in supervisor template in
	if (!empty($supervisorTemplate)) {
		$supervisorTemplate = run('cat "' . $supervisorTemplate . '"');
		$supervisorContents = parse($supervisorTemplate);
        // Create supervisor config file from template and add to server
        run('echo "' . base64_encode($supervisorContents) . '" | base64 -d > ' . get('release_path') . "/.supervisor-jobs");

		/**
		 * NOTE: IF YOU ARE RUNNING THIS ON PRODUCTION THEN SET application_name OR ELSE THIS WILL OVERWRITE OTHER SETUPS
		 */
        $slug = cdEnvironmentSlug();
        run("sudo symlink-supervisor {{release_path}}/.supervisor-jobs $slug");

        // Create the log file as the deploy user otherwise supervisor creates it as root and makes changing it difficult
        run("touch {{release_path}}/storage/logs/worker.log");

        invoke('supervisor:reloadconfig');
    }
});

task('supervisor:reloadconfig', function() {
    $slug = cdEnvironmentSlug();

    // Re-read in the config, update any changed configs and start supervisor for this application incase it hasn't already been
    run("sudo supervisorctl reread && sudo supervisorctl update && sudo supervisorctl start " . $slug . "-worker:*");
});

task('supervisor:destroy', function() {
    $slug = cdEnvironmentSlug();
    run("sudo remove-supervisor " . $slug);
})->desc('Destroys supervisor file for project');


