<?php

namespace Deployer;

require 'recipe/common.php';

set('shared_dirs', [
	'www/images/cms',
	'www/images/files',
	'www/templates_c',
	'www/admin/templates_c',
]);

set('shared_files', [
]);

set('writable_dirs', [
	'www/images/cms',
	'www/images/files',
	'www/templates_c',
	'www/admin/templates_c',
]);

task('deploy:set_release_path', function () {
	$releasePath = get('release_path') . '/www';
	set('release_path', $releasePath);
});

task('deploy', [
	'deploy:info',
	'deploy:prepare',
	'deploy:lock',
	'deploy:release',
	'deploy:update_code',
	'deploy:shared',
	'deploy:writable',
	'deploy:set_release_path',
	'deploy:vendors',
	'ci:setup:env',

	'deploy:symlink',
	'deploy:unlock',
	'cleanup',
])->desc('Deploy your project');

after('deploy', 'success');