# UPGRADING

## 2.9.9 to 3.0.0

The database provisioning API means changing some variables in your project's `deploy.php` file. As long as your project relies on a `.env` file (and it is currently being generated by deployer), this should be straightforward.

Replace these variables:

```php
set('cd_database_host', 'database.staging.evoluted.net');
set('cd_database_user', '***');
set('cd_database_password', '***');
set('seed_database', 'cd_photocentric_staging');
```

With:

```php
set('cd_db_type', 'mysql');
set('cd_db_version', '5.6');
set('cd_db_environment', 'cd');
set('cd_db_seed', 'cd_photocentric_staging');
```

You will also likely need to update your UAT host block to set different variables, e.g.

```php
host('uat.evoluted.net')
	->user('deploy')
	->stage('cd')
	->set('deploy_path', $cdDeployPath)
	->set('cd_database_host', 'evoluted-aws-cd-57.cluster-cenxuyrjyifk.eu-west-1.rds.amazonaws.com')
	->set('cd_database_user', '***')
	->set('cd_database_password', '***');
```

Will become:

```php
host('uat.evoluted.net')
	->user('deploy')
	->stage('cd')
	->set('deploy_path', $cdDeployPath)
	->set('cd_db_environment', 'uat')
	->set('cd_db_version', '5.7')
	->set('cd_db_seed', null);
```

You should also remove any triggers for the `ci:database:setup` task which has now been removed, e.g.

```php
after('ci:setup:env', 'ci:database:setup');
```

Nothing will need to change with your production host definition as the API won't be called on non-CD deployer runs.

When running as a pipeline, you should see the following entry:

```shell
➤ Executing task ci:database:provision
Sent the following to the database provisioning API: array (
  'type' => 'mysql',
  'version' => '5.6',
  'id' => 'photocentric-feature-database-provisioning',
  'environment' => 'cd',
  'seed' => 'cd_photocentric_staging',
)
Got the following from the database provisioning API: stdClass::__set_state(array(
   'host' => 'database.staging.evoluted.net',
   'username' => '***',
   'password' => '***',
   'port' => 3306,
   'dbname' => 'cd_photocentric_feature_database_provisioning',
))
```

The host, port, username, password and dbname will be written to your `.env` file which should have the following in it:

```shell
DB_HOST=REPLACE
DB_PORT=REPLACE
DB_DATABASE=REPLACE
DB_USERNAME=REPLACE
DB_PASSWORD=REPLACE
```

It's important to include the `DB_PORT` as in the future the provided database may not be on the default database port (3306 for MySQL, 5432 for Postgres).
