<?php
/**
 * Functions related to running deployer in a Gitlab CI/CD pipeline
 */

namespace Evoluted\Deployer\GitLab;

/**
 * Get the deploy path based upon the CI_PROJECT_NAME environment variable
 *
 * Also uses the environment variables CI_COMMIT_REF_SLUG and APPLICATION_PREFIX (if available)
 *
 * @return string
 */
function getDeployPath() {
    if (getenv('CI_PROJECT_NAME')) {
        return sprintf('/var/www/cd/%s/%s%s', getenv('CI_PROJECT_NAME'), getenv('CI_COMMIT_REF_SLUG'), getenv('APPLICATION_PREFIX'));
    }

    return getcwd() . '/test-deploy';
}

/**
 * Get the value of the CI_COMMIT_REF_SLUG environment variable
 *
 * @param string $default The default if CI_COMMIT_REF_SLUG isn't set or is empty
 * @return string
 */
function getBuildStage($default = null) {
    $buildRefSlug = getenv('CI_COMMIT_REF_SLUG');

    return !empty($buildRefSlug) ? strtolower($buildRefSlug) : $default;
}
