<?php

namespace Deployer;

use Deployer\Exception\RuntimeException;
use Deployer\Task\Context;

require_once 'general.php';

task('ci:database:provision', function () {
	$type = get('cd_db_type');
	$version = get('cd_db_version');
	$seed = get('cd_db_seed');
	$environment = get('cd_db_environment');

	$params = [
		'type' => $type,
		'version' => $version,
		'id' => cdEnvironmentSlug(),
		'environment' => $environment,
	];

	if (!empty($seed)) {
		$params['seed'] = $seed;
	}

	$http = curl_init();
	curl_setopt_array($http, [
		CURLOPT_URL => 'http://database-provisioner.tools.evoluted.net/api/1/provision',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_TIMEOUT => 300,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_HTTPHEADER => [
			'Content-Type: application/json',
		],
		CURLOPT_POSTFIELDS => json_encode($params),
	]);

	$response = curl_exec($http);
	$statusCode = intval(curl_getinfo($http, CURLINFO_HTTP_CODE));

	writeln('Sent the following to the database provisioning API: <info>' . var_export($params, true) . '</info>');

	if ($statusCode !== 201) {
		writeln('<error>Got a ' . $statusCode . ' from database provisioning API</error>');
		if (getenv('DEBUG_DEPLOYER')) {
			writeln(sprintf('Sent parameters: <info>%s</info>', var_export($params, true)));
			writeln(sprintf('Response: <info>%s</info>', $response));
		}

		throw new RuntimeException(
			Context::get()->getHost()->getHostname(),
			'ci:database:setup',
			$statusCode,
			'Error communicating with the database provisioning API',
			''
		);
	}

	$json = json_decode($response);

	if ($json === null) {
		writeln('<error>Could not decode database provisioning API JSON</error>');

		if (getenv('DEBUG_DEPLOYER')) {
			writeln(sprintf('Sent parameters: <info>%s</info>', var_export($params, true)));
			writeln(sprintf('Response: <info>%s</info>', $response));
		}

		throw new RuntimeException(
			Context::get()->getHost()->getHostname(),
			'ci:database:setup',
			$statusCode,
			'Error decoding database provisioning API content',
			''
		);
	}

	if (getenv('DEBUG_DEPLOYER')) {
		writeln('Got the following from the database provisioning API: <info>' . var_export($json, true) . '</info>');
	}

	set('cd_database_name', $json->dbname);
	set('cd_database_user', $json->username);
	set('cd_database_password', $json->password);
	set('cd_database_host', $json->host);
	set('cd_database_port', $json->port);
})->onStage('cd');

task('ci:database:teardown', function () {
	$type = get('cd_db_type');
	$version = get('cd_db_version');
	$environment = get('cd_db_environment');

	$params = [
		'type' => $type,
		'version' => $version,
		'id' => cdEnvironmentSlug(),
		'environment' => $environment,
	];

	$http = curl_init();
	curl_setopt_array($http, [
		CURLOPT_URL => 'http://database-provisioner.tools.evoluted.net/api/1/teardown',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_TIMEOUT => 10,
		CURLOPT_CUSTOMREQUEST => 'DELETE',
		CURLOPT_HTTPHEADER => [
			'Content-Type: application/json',
		],
		CURLOPT_POSTFIELDS => json_encode($params),
	]);

	$response = curl_exec($http);
	$statusCode = intval(curl_getinfo($http, CURLINFO_HTTP_CODE));

	if ($statusCode !== 200) {
		writeln('<error>Got a ' . $statusCode . ' from database provisioning API</error>');

		if (getenv('DEBUG_DEPLOYER')) {
			writeln(sprintf('Sent parameters: <info>%s</info>', var_export($params, true)));
			writeln(sprintf('Response: <info>%s</info>', $response));
		}

		throw new RuntimeException(
			Context::get()->getHost()->getHostname(),
			'ci:database:setup',
			$statusCode,
			'Error communicating with the database provisioning API',
			''
		);
	}

	writeln('<info>Database provisioning API teardown request successful</info>');
})->onStage('cd');
