<?php
class DeliveryRate extends EvDeliveryPriceBandAppModel  {

	public $belongsTo = array(
		'VatRate' => array(
			'className' => 'EvCheckout.VatRate'
		)
	);

	public function findBestDeliveryRate($orderSubtotal) {

		$params = array(
			'conditions' => array(
				$this->alias.'.is_active' => true,
				$this->alias.'.from_value <=' => $orderSubtotal,
				$this->alias.'.to_value >=' => $orderSubtotal,
			),
			'order' => array('cost' => 'asc'), 
			'contain' => 'VatRate'
		);

		$deliveryRate = $this->find('first', $params);

		if(! $deliveryRate) {
			return false;
		}

		//Separate off the VAT if the admin inc vat flag has been set
		$pricesAlreadyIncludeVAT = (bool) Configure::read('EvShop.prices_include_vat');

		if($pricesAlreadyIncludeVAT) {

			//Calculate cost minus VAT
			$deliveryRate[$this->alias]['cost'] = $deliveryRate[$this->alias]['cost'] / (1 + ($deliveryRate['VatRate']['rate'] / 100));

		}

		//Calculate VAT
		$deliveryRate[$this->alias]['vat'] = $deliveryRate[$this->alias]['cost'] * $deliveryRate['VatRate']['rate']/100;

		return $deliveryRate;

	}
	
	
}