<?php

App::uses('CakeEventListener', 'Event');

class DeliveryPriceBandListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Order.updateOrderTotal' => 'calculateDeliveryPriceBand',
		);
	}

	public function calculateDeliveryPriceBand(CakeEvent $event) {
		
		// Check to see if the delivery address has been set on the order?
		$data = $event->data['Order'];

		$DeliveryRate = ClassRegistry::init('EvDeliveryPriceBand.DeliveryRate'); 

		// Separate off the VAT if the admin inc vat flag has been set
		$adminPricesIncludeVAT = (bool) Configure::read('EvShop.prices_include_vat');

		if ($adminPricesIncludeVAT) {

			$cartTotal = $data['Order']['subtotal'] - $data['Order']['discount_total'] + $data['Order']['vat'];

		} else {

			$cartTotal = $data['Order']['subtotal'] - $data['Order']['discount_total'];

		}

		$bestRate = $DeliveryRate->findBestDeliveryRate($cartTotal); 

		if ($bestRate) {

			$subtotal = $bestRate[$DeliveryRate->alias]['cost'];
			$vat = $bestRate[$DeliveryRate->alias]['vat'];
			$total = $subtotal + $vat;

			$event->data['Order']['Order']['delivery_subtotal'] = $subtotal;
			$event->data['Order']['Order']['delivery_vat'] = $vat;
			$event->data['Order']['Order']['delivery_total'] = $total;

			$event->data['Order']['Order']['total'] += $total;
			$event->data['Order']['Order']['vat'] += $vat;

		}

		return;

	}

}