<?php
class DeliveryRatesController extends AppController {


	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'methods'
		));

	}


	public function methods($from = 0, $to = null) {
		
		$this->loadModel('Order');
		$data = $this->Order->getCart();
		$params = array(
			'conditions' => array(
				'is_active' => true,
				'from_value <=' => $data['Order']['total'],
				'to_value >=' => $data['Order']['total'],
			),
			'order' => array('cost' => 'asc')
		);

		return $this->DeliveryRate->find('all', $params);

	}


	/**
	 * Defines the fields displayed in a filter form.
	 *
	 * Defaults to id, display name, is_active, created and modified fields.
	 *
	 * Override in your controller to customise.
	 *
	 * Format:
	 *
	 * 'id' => array(
	 *         'label' => label text,
	 *         'type' => data type of control
	 *         'compare' => SQL query. e.g. Model.field='%s' (where %s is replace by the value of the field)
	 *         'default' => value you want the data filtering by by default
	 * )
	 */
	protected function _adminFilterFields() {

		return array();

	}


	public function _adminPopulateLookups() {

		$Model = $this->{$this->modelClass};
		$vatRates = $Model->VatRate->find('list');
		$this->set(compact('vatRates'));

	}


	/**
	 * Defines a whitelist of columns to be displayed on the admin index.
	 * @return array whitelisted columns
	 */
	protected function _adminIndexColumnsWhitelist() {

		$Model = $this->{$this->modelClass};
		$columns = parent::_adminIndexColumnsWhitelist(); 

		$columns[] = $Model->alias.".cost";
		$columns[] = $Model->alias.".from_value";
		$columns[] = $Model->alias.".to_value";

		return $columns;

	}


	public function _adminFormFields() {

		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();
	
		$fields[$Model->alias.'.cost']['label'] = 'Delivery Cost';
		$fields[$Model->alias.'.from_value']['label'] = 'Valid From Basket Price';
		$fields[$Model->alias.'.to_value']['label'] = 'Valid To Basket Price';

		return $fields;

	}


	public function _adminIndexColumns() {

		$columns = parent::_adminIndexColumns();
		$Model = $this->{$this->modelClass};

	    unset($columns[$Model->alias.".id"]);
	    unset($columns[$Model->alias.".created"]);
	    unset($columns[$Model->alias.".modified"]);

	    $columns[$Model->alias.".cost"]['label'] = 'Delivery Cost';
	    $columns[$Model->alias.".from_value"] = array('label' => 'Valid From Basket Price', 'type' => 'float');
	    $columns[$Model->alias.".to_value"] = array('label' => 'Valid To Basket Price', 'type' => 'float');
	    $columns[$Model->alias.".is_active"] = array('label' => 'Active', 'type' => 'boolean');
	    return $columns;

  	}

}