# EvCybertill

## Installation

This plugin requires [EvCheckout](https://git.evoluted.net/composer/evcheckout) so if you don't have that already then go and set that up first.

Run `composer require evoluted/cybertill` to get the plugin into your directory. Make sure the plugin is loaded and you are ready to go. There are no migrations or installing necessary.

## Setup

The plugin will mostly work out of the box with just a couple of additions needed in the config settings. Start by overriding the plugin config by adding the file `ev_cybertill.php` to your `app/Config/Plugin` directory.

The config settings are split into live/dev settings so that the settings used to test with can be different to their live counterparts. The live settings start empty and you will probably just copy them across when the site goes live, don't forget to do this.

The `url` and `user_id` inside `client_details` will need to be entered per project as these relate specifcally to the Cybertill account you are trying to access. Without these a client connection will not be able to be established and the plugin won't do a lot.

If you are going to be making Cybertill orders then you will also need to enter a customer id. If you do not have access to a customer id then you can provide the required information in the `customer_details` setting and a customer will be attempted to be made when making an order although this will probably only work once. To complete a Cybertill order then you will need to add the `despatch_user_id` to the config settings. This user id is different to the customer id and the user needs to have access to despatch orders. You will need to go into admin>user management, then get the edit user url and take the ID from there:

`https://ctaws-euw1-rs1.c-pos.co.uk/current/index.php/user/DISPATCH-USER-ID/edit`

Check through the rest of the config settings to make sure they are correct before you attempt to synchronise stock or make an order. The default config settings are based off of using the [EvShop](https://git.evoluted.net/composer/evshop) and [EvCheckout](https://git.evoluted.net/composer/evcheckout).

An item will need to be setup in Cybertill to represent delivery. Delivery charge is added as an item as well as within the delivery details so that the payment totals are calculated correctly. The SKU of the delivery item in Cybertill will need to be set in the config setting `order_delivery.delivery_item_sku`.

## Usage

To synchronise stock so that the stock in your project matches the current stock in Cybertill then there is a shell that will do all the heavy work. To use it just run the command `app/Console/cake EvCybertill.Cybertill syncStock`. This can also be used in a cronjob if you need to set it up to run regularly.

For Cybertill orders, there is an event that listens for a successful EvCheckout order. It will then queue a task to make the order when the queue is ran.

You can check the stock of a specific item by using the checkStock method in the shell. The SKU will neeed to be provided. To use it just run the command `app/Console/cake EvCybertill.Cybertill checkStock ITEM_SKU`.

## Reattempting a failed Cybertill Transaction
If a Cybertill transaction fails to be put through to Cybertill due to the product not being able to be found or if there isn't any stock etc. The transaction can be reattempted if the issue has been sorted. An element, `transaction.ctp`, has been included that displays the current status of a Cybertill transaction and contains the form that adds the transaction to the queue again. The `getAdminTransaction` method in the component can be used to acquire a Cybertill transaction.

A Cybertill transaction records how many times it has been attempted to be passed through to Cybertill and the last time it was attempted.

## Gift cards
Gift cards can be added to Cybertill and used by providing a gift card code. The `Cybertill::checkGiftCardBalance()` function will return the current balance of the card. If the card is unavailable then the balance will be 0.

Payments using gift cards should reduce the current balance of the gift card in Cybertill. To achieve this a total row needs to exist on the order called "Gift Card" and order data needs to exist called "giftCard" with the code inside. The order total name and data name can be changed in the configuration file. The gift card will be added as a separate payment on the Cybertill order. If the gift card is unavailable at the time of making the Cybertill order then the Cybertill order will fail. The Cybertill transaction will be updated to reflect this.

## Cybertill Documentation

This plugin is currently using the Cybertill SOAP API version 1.5. The documentation for this api is available here: [http://ct28790.c-pos.co.uk/current/docs/soap_documentation_v1_5/index.html]

## Possible issues

* When making an order, you may run into the issue that the payment totals don't match the sum of the item prices. The documentation says for both `transaction_add_salestax` and `transaction_add_giftcard` that payment totals should be inclusive of VAT and that item prices should be exclusive of VAT. When testing it was found that these didn't work when the price excluding VAT included a half pence. The solution was to make sure the customer account being used to place the order is of type *retail* and that item prices are inclusive of VAT.

* If you are outside the US it is advised that you use `transaction_add_giftcard` for your orders as `transaction_add_salestax` is only intended for customers inside the US.
