<?php if (! empty($cybertillTransaction)): ?>
	<div class="row">
		<div class="col-xs-12">
			<div class="panel panel-primary">
				<div class="panel-heading"><h3 class="panel-title">Cybertill Transaction</h3></div>
				<div class="panel-body">
					<div class="row">
						<div class="col-xs-12">
							<strong>Status:</strong> <?= $cybertillTransaction['CybertillTransactionStatus']['name'] ?><br>

							<?php if (!empty($cybertillTransaction['CybertillTransaction']['cybertill_transaction_id'])): ?>
								<strong>Transaction ID:</strong> <?= $cybertillTransaction['CybertillTransaction']['cybertill_transaction_id'] ?><br>
							<?php endif; ?>

							<?php if ($cybertillTransaction['CybertillTransaction']['is_successful'] === false): ?>
								<strong>Last Attempted:</strong> <?= $cybertillTransaction['CybertillTransaction']['last_attempted'] ?><br>
								<strong>Attempts:</strong> <?= $cybertillTransaction['CybertillTransaction']['attempts'] ?><br>

								<?php if (!empty($cybertillTransaction['CybertillTransaction']['failure_message'])): ?>
									<strong>Failure Message:</strong> <?= $cybertillTransaction['CybertillTransaction']['failure_message'] ?>
								<?php endif; ?>
							<?php endif; ?>
						</div>
					</div>

					<div class="row">
						<div class="col-xs-12">
							<?php if ($cybertillTransaction['CybertillTransaction']['is_queueable'] === true): ?>
								<?php
									echo $this->Form->create(
										'CybertillTransaction',
										[
											'url' => [
												'plugin' => 'ev_cybertill',
												'admin' => true,
												'controller' => 'cybertill_transactions',
												'action' => 'reattempt_transaction',
												$cybertillTransaction['CybertillTransaction']['id']
											]
										]
									);
								?>
									<?php
										echo $this->Form->input(
											'CybertillTransaction.id',
											[
												'type' => 'hidden',
												'value' => $cybertillTransaction['CybertillTransaction']['id']
											]
										);

										echo $this->Form->button(
											'Re-attempt Transaction',
											[
												'type' => 'submit',
												'name' => 'submit',
												'class' => 'btn btn-primary'
											]
										);
									?>
								<?= $this->Form->end() ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>
