<?php
App::uses('EvCybertillAppModel', 'EvCybertill.Model');

class CybertillTransactionStatus extends EvCybertillAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Status must be filled in'
			),
		),
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'CybertillTransaction' => array(
			'className' => 'EvCybertill.CybertillTransaction'
		)
	);

	public $statuses = array(
		'pending' => 1,
		'successful' => 2,
		'failed' => 3,
		'queued' => 4,
		'notDispatched' => 5
	);

/**
 * Get a list of the current Cybertill transaction statuses
 * @return array The list of statuses
 */
	public function getStatusList() {
		return $this->find(
			'list',
			[
				'conditions' => [
					'CybertillTransactionStatus.is_active' => true,
				],
				'order' => ['CybertillTransactionStatus.sequence ASC', 'CybertillTransactionStatus.id ASC']
			]
		);
	}
}
