<?php

App::uses('CakeEventListener', 'Event');

class EvCheckoutOrderSuccessListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'createCybertillOrder'
		);
	}

	/**
	 * Reduce the stock levels for the given item
	 *
	 * @param 	CakeEvent
	 */
	public function createCybertillOrder(CakeEvent $Event) {
		// 'orderId' should be set in data
		if (empty($Event->data['orderId'])) {
			return false;
		}

		$CybertillTransaction = EvClassRegistry::init('EvCybertill.CybertillTransaction');

		$result = $CybertillTransaction->createTransaction(
			$CybertillTransaction->readForCybertillTransaction(
				$Event->data['orderId']
			),
			'EvCheckout.Order',
			'Order.id'
		);

		return $result;
	}
}
