<?php

App::uses('EvCybertillAppController', 'EvCybertill.Controller');

class CybertillTransactionsController extends EvCybertillAppController {

	public function beforeFilter() {
		$this->adminActions[] = 'admin_reattempt_transaction';
	}

/**
 * Queue a Cybertill transaction so that the transaction is recorded in Cybertill. Redirect defaults to
 * returning to EvCheckout orders page. Redirect can be defined in the config file.
 * @param  int $id The Id of the transaction to queue
 */
	public function admin_reattempt_transaction($id) {
		$jobResult = $this->CybertillTransaction->createTransactionJob($id);

		if ($jobResult) {
			$this->Flash->success(
				array(
					'title' => 'Cybertill Transaction Queued',
					'description' => 'The Cybertill transaction has been queued.'
				)
			);
		} else {
			$this->Flash->fail(
				array(
					'title' => 'Failed',
					'description' => 'There was a problem reattempting to queue your Cybertill transaction.'
				)
			);
		}
		$cybertillTransaction = $this->CybertillTransaction->findById($id);

		$redirect = Configure::read('EvCybertill.redirects.reattempt');

		if (!empty($redirect)) {
			if (!empty($cybertillTransaction)) {
				$redirect[] = $cybertillTransaction['CybertillTransaction']['model_id'];
			}

			return $this->redirect($redirect);
		}

		// Default redirect
		return $this->redirect(
			[
				'plugin' => 'ev_checkout',
				'controller' => 'orders',
				'action' => 'edit',
				'admin' => true,
				$cybertillTransaction['CybertillTransaction']['model_id']
			]
		);
	}
}
