<?php

App::uses('AppComponent', 'Controller/Component');

class CybertillTransactionsComponent extends AppComponent {

/**
 * Get a specific transaction for an admin page.
 * @param  string $model   The model the Cybertill transaction required is related to
 * @param  int    $modelId The id of the Cybertill transaction is related to.
 * @return array           An array of the requested Cybertill yransaction and it's current status
 */
	public function getAdminTransaction($model, $modelId) {
		$CybertillTransaction = EvClassRegistry::init('EvCybertill.CybertillTransaction');
		return $CybertillTransaction->find(
			'first',
			[
				'conditions' => [
					'CybertillTransaction.model' => $model,
					'CybertillTransaction.model_id' => $modelId
				],
				'contain' => [
					'CybertillTransactionStatus'
				]
			]
		);
	}
}
