<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');

App::uses('Cybertill', 'EvCybertill.Lib');

/**
 * A Simple QueueTask example.
 *
 */
class QueueCybertillOrderTask extends QueueTask {

/**
 * "Add" the task, not possible for QueueEmailTask
 *
 * @return void
 */
	public function add() {
		$this->err('Queue Cybertill Order Task cannot be added via Console.');
	}

/**
 * QueueCybertillOrderTask::run()
 *
 * @param mixed $data Job data
 * @param int $id The id of the QueuedTask
 * @return bool Success
 */
	public function run($data, $id = null) {
		if (!empty($data)) {
			$data = json_decode($data);

			$CybertillTransaction = EvClassRegistry::init('EvCybertill.CybertillTransaction');
			return $CybertillTransaction->makeOrder($data);
		}

		return false;
	}

}
