<?php

App::uses('PluginInstallShell', 'shells');

class EvCybertillInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvCybertill.CybertillTransactionStatus'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$date = date('Y-m-d H:i:s');

		$this->CybertillTransactionStatus->saveMany(
			array(
				array(
					'CybertillTransactionStatus' => array(
						'id' => 1,
						'name' => 'Pending',
						'sequence' => 10,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'CybertillTransactionStatus' => array(
						'id' => 2,
						'name' => 'Successful',
						'sequence' => 20,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'CybertillTransactionStatus' => array(
						'id' => 3,
						'name' => 'Failed',
						'sequence' => 30,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'CybertillTransactionStatus' => array(
						'id' => 4,
						'name' => 'Queued',
						'sequence' => 40,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'CybertillTransactionStatus' => array(
						'id' => 5,
						'name' => 'Not Dispatched',
						'sequence' => 25,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);
	}
}
