<?php

App::uses('AppShell', 'Console/Command');

class CybertillShell extends AppShell {

	protected $_Cybertill;

/**
 * Find an extended version of the Cybertill class and if one exists, use that.
 *
 * {@inheritDoc}
 */
	public function __construct($stdout = null, $stderr = null, $stdin = null) {
		parent::__construct($stdout, $stderr, $stdin);

		App::uses('EvCybertillCybertill', 'Lib');
		if (class_exists('EvCybertillCybertill')) {
			$this->_Cybertill = new EvCybertillCybertill();
		}

		if (empty($this->_Cybertill)) {
			App::uses('Cybertill', 'EvCybertill.Lib');
			$this->_Cybertill = new Cybertill();
		}
	}

/**
 * Sync the stock so that the stock on the site matches with the stock in cybertill.
 */
	public function pull() {
		$this->_Cybertill->pull();
	}

/**
 * @deprecated Since 2.3.1.0
 */
	public function syncStock() {
		trigger_error(
			'syncStock is deprecated since 2.3.1.0 and will be removed in 2.4.0.0, use pull()',
			E_USER_DEPRECATED
		);

		$this->pull();
	}

/**
 * Use this shell command to check the stock of a specific item in cybertill. Uses the details in the config
 * to establish a connection to cybertill and checks for stock of the provided SKU.
 * @param  arg[0] The SKU of the item to check stock of.
 */
	public function checkStock() {
		if (!empty($this->args[0])) {
			$sku = $this->args[0];

			$stock = $this->_Cybertill->checkStock($sku);

			if ($stock['success'] === true) {
				$this->out("\n Product with sku: " . $sku . ' has ' . $stock['stock']->item->stock . " items in stock. \n");
				$this->out("\n Product with sku: " . $sku . ' has ' . $stock['stock']->item->reserved . " items reserved. \n");
			} else {
				$this->out("\n Product with sku: " . $sku . " has no items in stock. \n");
			}
		}
	}

/**
 * Use this shell command to check the pricing of a specific item in cybertill.
 *
 * Uses the details in the config to establish a connection to cybertill and checks for the price of the provided SKU.
 *
 * @param  arg[0] The SKU of the item to check stock of.
 */
	public function checkPricing() {
		if (!empty($this->args[0])) {
			$sku = $this->args[0];

			$pricing = $this->_Cybertill->checkPricing($sku);

			if ($pricing['success'] === true) {
				$prices = [
					'RRP is '.$pricing['pricing']->priceRrp,
					'Staff is '.$pricing['pricing']->priceStaff,
					'Store is '.$pricing['pricing']->priceStore,
					'Trade is '.$pricing['pricing']->priceTrade,
					'Web is '.$pricing['pricing']->priceWeb,
				];

				$this->out("\nPricing for product (" . $sku . ") " . implode(', ', $prices) . "\n");
			} else {
				$this->out("\nCouldn't find pricing for product with SKU: " . $sku . "\n");
			}
		}
	}

/**
 * Pull the stock and pricing of a specific item so that the item on the site matches the item in cybertill.
 *
 * @param  arg[0] The SKU of the item to sync with.
 * @param  arg[1] The model of the item. E.g. 'EvShop.Variant'
 */
	public function pullItem() {
		if (!empty($this->args[0]) && !empty($this->args[1])) {
			$sku = $this->args[0];
			$itemModel = $this->args[1];

			$ItemModel = EvClassRegistry::init($itemModel);

			$item = $ItemModel->find(
				'first',
				[
					'conditions' => [
						$ItemModel->alias . '.sku' => $sku
					]
				]
			);

			if (!empty($item)) {
				$this->_Cybertill->pullItem($sku, $item, $ItemModel);
			}
		} else {
			$this->out("\nPlease provide an sku and the model the sku belongs to.\n");
		}
	}

/**
 * @deprecated Since 2.3.1.0
 */
	public function syncItemStock() {
		trigger_error(
			'syncItemStock is deprecated since 2.3.1.0 and will be removed in 2.4.0.0, use pullItem()',
			E_USER_DEPRECATED
		);

		$this->pullItem();
	}

/**
 * Use this shell command to set the stock of an item in cybertill. The stock is set to the specified value
 * instead of incrementing or decrementing the value currently in cybertill. The maximum and minimum values
 * are able to be set through this command.
 * @param  arg[0] The SKU of the tiem to set the stock of
 * @param  arg[1] The amount of stock to set.
 */
	public function setStock() {
		if (!empty($this->args[0]) && isset($this->args[1])) {
			$sku = $this->args[0];
			$stockAmount = $this->args[1];

			$this->_Cybertill->setStock($sku, $stockAmount);
		} else {
			$this->out("\nPlease provide an sku and the amount of stock you want the product to have.\n");
		}
	}

/**
 * Create a Cybertill transaction from an existing order.
 * Intended to be used to create transactions from orders that would have already attempted to go through to cybertill
 * and failed before the transactions were recorded. The new transaction will be queue immediately as standard.
 * @param arg[0] The order model to create the transaction from.
 * @param arg[1] The id of the order to create the transaction from.
 * @param arg[2] The path of the order id in the order data.
 */
	public function createTransactionFromOrder() {
		if (!empty($this->args[0]) && !empty($this->args[1]) && !empty($this->args[2])) {
			$model = $this->args[0];
			$id = $this->args[1];
			$idPath = $this->args[2];

			$Model = EvClassRegistry::init($model);
			$transactionData = $Model->readForView($id);

			if (!empty($transactionData)) {
				$CybertillTransaction = EvClassRegistry::init('EvCybertill.CybertillTransaction');
				$result = $CybertillTransaction->createTransaction(
					$transactionData,
					$model,
					$idPath
				);
			}
		} else {
			$this->out("\nPlease provide the model and the id you wish to create a cybertill transaction of. Please also provide the path to the id in the data\n");
		}
	}

}
